//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F2 - Recursive Inverse Dynamics of tree-like MBS
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

 
void mbs_invdyna(double *Qq,
MbsData *s, double tsim)
{
#include "mbs_invdyna_pendulum_spring_c.h"

double *q, *qd, *qdd;
double *g, *m;
double **l, **In, **dpt, **frc, **trq;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
l   = s->l;

m = s->m;
In  = s->In;

frc = s->frc;
trq = s->trq;
g = s->g;
 
// Trigonometric functions

S1 = sin(q[1]);
C1 = cos(q[1]);
S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Augmented Joint Position Vectors

 
// Forward Kinematics

BS91 = -qd[1]*qd[1];
ALPHA11 = g[3]*S1;
ALPHA31 = -g[3]*C1;
ALPHA12 = ALPHA11+(2.0)*qd[1]*qd[2]+qdd[1]*Dz23;
ALPHA32 = qdd[2]+ALPHA31+BS91*Dz23;
BS93 = -qd[3]*qd[3];
ALPHA13 = g[3]*S3;
ALPHA33 = -g[3]*C3;
OM24 = qd[3]+qd[4];
OMp24 = qdd[3]+qdd[4];
BS94 = -OM24*OM24;
ALPHA14 = C4*(ALPHA13+qdd[3]*dpt[3][6])-S4*(ALPHA33+BS93*dpt[3][6]);
ALPHA34 = C4*(ALPHA33+BS93*dpt[3][6])+S4*(ALPHA13+qdd[3]*dpt[3][6]);
 
// Backward Dynamics

Fs14 = -frc[1][4]+m[4]*(ALPHA14+OMp24*l[3][4]);
Fs34 = -frc[3][4]+m[4]*(ALPHA34+BS94*l[3][4]);
Cq24 = -trq[2][4]+In[5][4]*OMp24+Fs14*l[3][4];
Fs13 = -frc[1][3]+m[3]*(ALPHA13+qdd[3]*l[3][3]);
Cq23 = -trq[2][3]+Cq24+qdd[3]*In[5][3]+Fs13*l[3][3]+dpt[3][6]*(Fs14*C4+Fs34*S4);
Fs12 = -frc[1][2]+m[2]*ALPHA12;
Fs32 = -frc[3][2]+m[2]*ALPHA32;
Fs11 = -frc[1][1]+m[1]*(ALPHA11+qdd[1]*l[3][1]);
Cq21 = -trq[2][1]-trq[2][2]+qdd[1]*In[5][1]+Fs11*l[3][1]+Fs12*Dz23;
 
// Symbolic model output

Qq[1] = Cq21;
Qq[2] = Fs32;
Qq[3] = Cq23;
Qq[4] = Cq24;

// Number of continuation lines = 0

}
